#ifndef USER_ENV_MESSAGE_H
#define USER_ENV_MESSAGE_H

#include "EnvMessage.h"
//#include "Environment.h"

#define USER_ENV_MESSAGE_API_VER 1

//class Environment;

class UserEnvMessage : public EnvMessage {
	public:
		UserEnvMessage(BLooper *env) : EnvMessage(env) {}
		int Ver() { return USER_ENV_MESSAGE_API_VER; }
		// Environment *GetEnv() { return env;} // for debugging
		
		// Messages sent to environment
		// Arm numbers are between 0 and numArms-1 (inclusive)
      	bool IsArbitraryDoorOpen(int armNumber); // no constraint on rat being at center
      	void PlaceFood(int armNumber);
      	void RemoveFood(int armNumber);
      	void OpenDoor(int armNumber);
      	void CloseDoor(int armNumber);
      	void WarpTo(int armNumber); // put rat at location
      	bool IsFoodAtLocation(int armNumber); // food on this arm?
      	void GetRatLocation(int &armNumber); // return the location of the rat
      	
      	// what is the current head orientation of rat? Result is returned in degress.
      	// Zero degrees is North, 90 degrees is East, etc.
      	// Heading will be between 0 and 259 inclusive (headings are normalized).
      	int GetCurrHeading(); 
      	
      	// set/get number of arms on maze
      	void SetNumberOfMazeArms(int numArms);
      	int GetNumberOfMazeArms();
      	
      	bool GetDisplayChange(); // has environment content changed?
      	void ResetDisplayChange(); // reset display change indicator to false
};

#endif
